DECLARE KeyValue VARCHAR(10);
//SET KeyValue = '00006';
SET KeyValue = {KeyValue};

DECLARE xOffertenr VARCHAR(10);
SET xOffertenr = (SELECT DISTINCT(f.Offertenr) FROM Facturen f WHERE f.Faktuurnr = KeyValue);

DECLARE xTermijn INT;
SET xTermijn = (SELECT DISTINCT(Termijn) FROM Facturen WHERE Faktuurnr = KeyValue);

SELECT
  Omschrijving,
  CASE WHEN Bedrag IS NOT NULL THEN '' ELSE '' END AS Euro1,
  Bedrag,
  CASE WHEN FaktuurBedrag IS NOT NULL THEN '' ELSE '' END AS Euro2,
  FaktuurBedrag
FROM
( SELECT TOP 1
  0 AS Termijn,
  'Aanneemsom ' AS Omschrijving,
  CASE
    WHEN f.BTWVerlegd = 'N' OR f.BTWVerlegd IS NULL THEN o.VastBedrag + o.SamengesteldeBTW
    WHEN f.BTWVerlegd = 'J'  THEN o.VastBedrag
  END AS Bedrag,
  CAST(NULL AS MONEY) AS FaktuurBedrag
FROM Offertes      o 
LEFT JOIN Facturen f ON (f.Offertenr = o.Offertenr)
WHERE (f.Offertenr  = xOffertenr)

UNION ALL

SELECT
  Termijn,
  'Termijn ' || TOSTRING(Termijn) AS Omschrijving,
  CASE WHEN (Faktuurnr <> KeyValue) AND (Termijn <= xTermijn) THEN
    CASE
      WHEN BTWVerlegd = 'N' OR f.BTWVerlegd IS NULL THEN FaktuurBedrag + SamenGesteldeBTW
      WHEN BTWVerlegd = 'J'  THEN FaktuurBedrag
    END
  ELSE
    CAST(NULL AS MONEY)
  END AS Bedrag,

  CASE WHEN (Faktuurnr = KeyValue) THEN
    FaktuurBedrag
  ELSE
    CAST(NULL AS MONEY)
  END AS FaktuurBedrag
FROM Facturen
WHERE (Offertenr =  xOffertenr) AND (Termijn <= xTermijn)
)

ORDER BY Termijn;
